---
title: "Taxonomy Support"
linkTitle: "Taxonomy Support"
weight: 10
tags: ["Tagging", "Structuring Content", "Labelling"]
categories: ["Taxonomies"]
description: >
  Structure the content using taxonomies like tags, categories, labels.
---

Docsy supports Hugo's Taxonomies (see: https://gohugo.io/content-management/taxonomies/) in its docs and blog section. You can see the default layout and can test the behavior of the generated links on this page. 

## Terminology

To understand the usage of taxonomies you should understand the following terminology:

Taxonomy
: a categorization that can be used to classify content - e.g.: Tags, Categories, Projects, People

Term
: a key within the taxonomy - e.g. within projects: Project A, Project B

Value
: a piece of content assigned to a term - e.g. a page of your site, that belongs to a specific project

A example taxonomy for a movie website you can find in the official Hugo docs: https://gohugo.io/content-management/taxonomies/#example-taxonomy-movie-website

## Parameters

There are various parameter to control the functionality of taxonomies in the `config.toml`.

By default taxonomies for `tags` and `categories` are enabled in Hugo (see: https://gohugo.io/content-management/taxonomies/#default-taxonomies). In Docsy taxonomies are __disabled__ by default in the `config.toml`/`config.yaml`/`config.json`:

{{< tabpane persistLang=false >}}
{{< tab header="Configuration file:" disabled=true />}}
{{< tab header="config.toml" lang="toml" >}}
disableKinds = ["taxonomy", "taxonomyTerm"]
{{< /tab >}}
{{< tab header="config.yaml" lang="yaml" >}}
disableKinds:
  - taxonomy
  - taxonomyTerm
{{< /tab >}}
{{< tab header="config.json" lang="json" >}}
{
  "disableKinds": [
    "taxonomy",
    "taxonomyTerm"
  ]
}
{{< /tab >}}
{{< /tabpane >}}

If you want to enable taxonomies in Docsy you have to delete (or comment out) this line in your projects `config.toml`/`config.yaml`/`config.json`. Then the taxonomy pages for `tags` and `categories` will be generated by Hugo. If you want to use other taxonomies you have to define them in your `config.toml`. If you want to use beside your own taxonomies also the default taxonomies `tags` and `categories`, you also have to define them beside your own taxonomies. You need to provide both the plural and singular labels for each taxonomy.

With the following example you define a additional taxonomy `projects` beside the default taxonomies `tags` and `categories`:

{{< tabpane persistLang=false >}}
{{< tab header="Configuration file:" disabled=true />}}
{{< tab header="config.toml" lang="toml" >}}
[taxonomies]
tag = "tags"
category = "categories"
project = "projects"
{{< /tab >}}
{{< tab header="config.yaml" lang="yaml" >}}
taxonomies:
  tag: tags
  category: categories
  project: projects
{{< /tab >}}
{{< tab header="config.json" lang="json" >}}
{
  "taxonomies": {
    "tag": "tags",
    "category": "categories",
    "project": "projects"
  }
}
{{< /tab >}}
{{< /tabpane >}}

You can use the following parameters in your projects `config.toml`/`config.yaml`/`config.json` to control the output of the assigned taxonomy terms for each article resp. page of your docs and/or blog section in Docsy or a "tag cloud" in Docsy's right sidebar:

{{< tabpane persistLang=false >}}
{{< tab header="Configuration file:" disabled=true />}}
{{< tab header="config.toml" lang="toml" >}}
[params.taxonomy]
taxonomyCloud = ["projects", "tags"] # set taxonomyCloud = [] to hide taxonomy clouds
taxonomyCloudTitle = ["Our Projects", "Tag Cloud"] # if used, must have same length as taxonomyCloud
taxonomyPageHeader = ["tags", "categories"] # set taxonomyPageHeader = [] to hide taxonomies on the page headers
{{< /tab >}}
{{< tab header="config.yaml" lang="yaml" >}}
params:
  taxonomy:
    taxonomyCloud:
      - projects    # remove all entries
      - tags        # to hide taxonomy clouds
    taxonomyCloudTitle:   # if used, must have the same
      - Our Projects      # number of entries as taxonomyCloud
      - Tag Cloud
    taxonomyPageHeader:
      - tags        # remove all entries
      - categories  # to hide taxonomy clouds
{{< /tab >}}
{{< tab header="config.json" lang="json" >}}
{
  "params": {
    "taxonomy": {
      "taxonomyCloud": [
        "projects",
        "tags"
      ],
      "taxonomyCloudTitle": [
        "Our Projects",
        "Tag Cloud"
      ],
      "taxonomyPageHeader": [
        "tags",
        "categories"
      ]
    }
  }
}
{{< /tab >}}
{{< /tabpane >}}

The settings above would only show a taxonomy cloud for `projects` and `tags` (with the headlines "Our Projects" and "Tag Cloud") in Docsy's right sidebar and the assigned terms for the taxonomies `tags` and `categories` for each page. 

To disable any taxonomy cloud you have to set the Parameter `taxonomyCloud = []` resp. if you don't want to show the assigned terms you have to set `taxonomyPageHeader = []`. 

As default the plural label of a taxonomy is used as it cloud title. You can overwrite the default cloud title with `taxonomyCloudTitle`. But if you do so, you have to define a manual title for each enabled taxonomy cloud (`taxonomyCloud` and `taxonomyCloudTitle` must have the same length!). 

If you don't set the parameters `taxonomyCloud` resp. `taxonomyPageHeader` the taxonomy clouds resp. assigned terms for all defined taxonomies will be generated.
## Partials

The by default used partials for displaying taxonomies are so defined, that you should be able to use them also easily in your own layouts.

### taxonomy_terms_article

The partial `taxonomy_terms_article` shows all assigned terms of an given taxonomy (partial parameter `taxo`) of an article respectively page (partial parameter `context`, most of the time the current page or context `.`).

Example usage in `layouts/docs/list.html` for the header of each page in the docs section:

```go-html-template
{{ $context := . }}
{{ range $taxo, $taxo_map := .Site.Taxonomies }}
  {{ partial "taxonomy_terms_article.html" (dict "context" $context "taxo" $taxo ) }}
{{ end }}
```

This will gave you for each in the current page (resp. context) defined taxonomy a list with all assigned terms:
```html
<div class="taxonomy taxonomy-terms-article taxo-categories">
  <h5 class="taxonomy-title">Categories:</h5>
  <ul class="taxonomy-terms">
    <li><a class="taxonomy-term" href="//localhost:1313/categories/taxonomies/" data-taxonomy-term="taxonomies"><span class="taxonomy-label">Taxonomies</span></a></li>
  </ul>
</div>
<div class="taxonomy taxonomy-terms-article taxo-tags">
  <h5 class="taxonomy-title">Tags:</h5>
  <ul class="taxonomy-terms">
    <li><a class="taxonomy-term" href="//localhost:1313/tags/tagging/" data-taxonomy-term="tagging"><span class="taxonomy-label">Tagging</span></a></li>
    <li><a class="taxonomy-term" href="//localhost:1313/tags/structuring-content/" data-taxonomy-term="structuring-content"><span class="taxonomy-label">Structuring Content</span></a></li>
    <li><a class="taxonomy-term" href="//localhost:1313/tags/labelling/" data-taxonomy-term="labelling"><span class="taxonomy-label">Labelling</span></a></li>
  </ul>
</div>
```

### taxonomy_terms_article_wrapper

The partial `taxonomy_terms_article_wrapper` is a wrapper for the partial `taxonomy_terms_article` with the only parameter `context` (most of the time the current page or context `.`) and checks the taxonomy parameters of your project's `config.toml`/`config.yaml`/`config.json` to loop threw all listed taxonomies in the parameter `taxonomyPageHeader` resp. all defined taxonomies of your page, if `taxonomyPageHeader` isn't set.

### taxonomy_terms_cloud

The partial `taxonomy_terms_cloud` shows all used terms of an given taxonomy (partial parameter `taxo`) for your site (partial parameter `context`, most of the time the current page or context `.`) and with the parameter `title` as headline.

Example usage in partial `taxonomy_terms_clouds` for showing all defined taxonomies and its terms:

```go-html-template
{{ $context := . }}
{{ range $taxo, $taxo_map := .Site.Taxonomies }}
  {{ partial "taxonomy_terms_cloud.html" (dict "context" $context "taxo" $taxo "title" ( humanize $taxo ) ) }}
{{ end }}
```

As an example this will gave you for following HTML markup for the taxonomy `categories`:
```html
<div class="taxonomy taxonomy-terms-cloud taxo-categories">
  <h5 class="taxonomy-title">Cloud of Categories</h5>
  <ul class="taxonomy-terms">
    <li><a class="taxonomy-term" href="//localhost:1313/categories/category-1/" data-taxonomy-term="category-1"><span class="taxonomy-label">category 1</span><span class="taxonomy-count">3</span></a></li>
    <li><a class="taxonomy-term" href="//localhost:1313/categories/category-2/" data-taxonomy-term="category-2"><span class="taxonomy-label">category 2</span><span class="taxonomy-count">1</span></a></li>
    <li><a class="taxonomy-term" href="//localhost:1313/categories/category-3/" data-taxonomy-term="category-3"><span class="taxonomy-label">category 3</span><span class="taxonomy-count">2</span></a></li>
    <li><a class="taxonomy-term" href="//localhost:1313/categories/category-4/" data-taxonomy-term="category-4"><span class="taxonomy-label">category 4</span><span class="taxonomy-count">6</span></a></li>
  </ul>
</div>
```

### taxonomy_terms_clouds

The partial `taxonomy_terms_clouds` is a wrapper for the partial `taxonomy_terms_cloud` with the only parameter `context` (most of the time the current page or context `.`) and checks the taxonomy parameters of your project's `config.toml`/`config.yaml`/`config.json` to loop threw all listed taxonomies in the parameter `taxonomyCloud` resp. all defined taxonomies of your page, if `taxonomyCloud` isn't set.

## Multi language support for taxonomies

The taxonomy terms associated content gets only counted and linked WITHIN the language! The control parameters for the taxonomy support can also get assigned language specific.
